/*
  Ball messages for Bombing Run game. 
  Author Mark Caldwell aka W@rHe@d of The Reliquary
*/
class UTBRBallMessage extends UTOnslaughtOrbMessage;


static simulated function ClientReceive(
	PlayerController P,
	optional int SwitchIndex,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	//local UTTeamInfo OrbTeam;
	//local UTOnslaughtFlag Orb;
	//local int BaseSwitch;


/*
gotta remove this code or Player killed the Orb Carrier messages get replaced with Enemy Orb Dropped.
also below code would cause the Orb Taken message to not display if player could not see the ball.


	// if enemy orb, either switch to custom message or ignore, depending on whether in sensor range
	// not for "enemy orb carrier incoming" as in that case distance was already checked
	if ( SwitchIndex != 14 && SwitchIndex != 17 && SwitchIndex != 18 )
	{
		OrbTeam = UTTeamInfo(OptionalObject);
		if ( (OrbTeam != None) && (P.PlayerReplicationInfo.Team != OrbTeam) )
		{
			Orb = UTOnslaughtFlag(OrbTeam.TeamFlag);
			if ( Orb != None )
			{
				if ( !LocalPlayer(P.Player).GetActorVisibility(Orb) && (P.PlayerReplicationInfo != RelatedPRI_1) && (P.PlayerReplicationInfo != RelatedPRI_2)
					&& ((Orb.LastNearbyObjective == None)
					|| (VSize(Orb.Location - Orb.LastNearbyObjective.Location) > Orb.LastNearbyObjective.MaxSensorRange)) )
				{
					return;
				}

				BaseSwitch = (SwitchIndex<7) ? SwitchIndex : SwitchIndex-7;
				// switch to custom message
				if ( BaseSwitch == 2 )
				{
					// enemy dropped
					SwitchIndex = 15;
				}
				else if ( (BaseSwitch == 1) || (BaseSwitch == 3) || (BaseSwitch == 5) )
				{
					// enemy destroyed (returned)
					SwitchIndex = 16;
				}
			}
		}
	}
	
*/
	Super(UTCarriedObjectMessage).ClientReceive(P, SwitchIndex, RelatedPRI_1, RelatedPRI_2, OptionalObject);

	if ( RelatedPRI_1 == P.PlayerReplicationInfo )
	{
		if ( (SwitchIndex == 16) )
		{
			UTPlayerController(P).ClientMusicEvent(3);
		}
	}
}

//fixed from base class for br to return a value at end of function
static function SoundNodeWave AnnouncementSound(int MessageIndex, Object OptionalObject, PlayerController PC)
{
	if ( MessageIndex < 14 )
	{
		return super(UTCarriedObjectMessage).AnnouncementSound(MessageIndex, OptionalObject, PC);
	}
	else if ( MessageIndex == 14 )
	{
		return Default.EnemyIncoming;
	}
	else if ( MessageIndex == 15 )
	{
		return Default.EnemyDropped;
	}
	else if ( MessageIndex == 16 )
	{
		return Default.EnemyDestroyed;
	}
	
	return none;
}

//fixed from base class for br to return a value at end of function
static function string GetString(
	optional int Switch,
	optional bool bPRI1HUD,
	optional PlayerReplicationInfo RelatedPRI_1,
	optional PlayerReplicationInfo RelatedPRI_2,
	optional Object OptionalObject
	)
{
	if ( Switch < 14 )
	{
		return super(UTCarriedObjectMessage).GetString(Switch, bPRI1HUD, RelatedPRI_1, RelatedPRI_2, OptionalObject);
	}
	else if ( Switch == 14 )
	{
		return Default.EnemyIncomingString;
	}
	else if ( Switch == 15 )
	{
		return Default.EnemyDroppedString;
	}
	else if ( Switch == 16 )
	{
		return Default.EnemyDestroyedString;
	}
	else if ( Switch == 17 )
	{
		return Default.OrbAutoReturnedString;
	}
	else if ( Switch == 18 )
	{
		return Default.OrbNoPickupString;
	}
	
	return "";
}

defaultproperties
{
   Name="Default__UTBRBallMessage"
   ObjectArchetype=UTOnslaughtOrbMessage'UTGameContent.Default__UTOnslaughtOrbMessage'
}

